  ; FENSTER TFT-Textdisplay
.equ __33EP32MC502, 1
.include "p33EP32MC502.inc"
.include "ram.inc"
.include "allgdef.inc"

.global __DefaultInterrupt
.global __OscillatorFail
.global __HardTrapError
.global __StackError,__MathError,__DMACError,__SoftTrapError
.global	__reset
.global __T1Interrupt
.global __U1RXInterrupt
.global	__DefaultInterrupt

; Debuger
config	__FICD,ICS_PGD2 & JTAGEN_OFF
; OSC2 auf normal IO
config  __FOSC,OSCIOFNC_ON  & FCKSM_CSECME
; Oszillator auf intern 7,37MHz, und Taktumschaltung erlauben
config 	__FOSCSEL,FNOSC_FRC; & IESO_ON
; Wachhund = aus
config	__FWDT,FWDTEN_OFF


; RAM
.section	MAINRAM, bss, address(0x1050)

.text	

;-----------------------------------------------------	
__reset:

;stack setzen
 	mov 	#stackanfang,w15
	mov 	#stackanfang+100,W0
	mov 	W0,_SPLIM
; RAM lschen
 	mov		#0x1050,w0
 	repeat	#(ramende-ramanfang)
 	clr		[w0++]
	nop
; Puffer lschen
 	mov		#0x1800,w0
 	repeat	#(ringende - rs232cpuffer)
 	clr		[w0++]


; Oszillator schalten auf 30 MIPS
	call	OszillatorSetzen

; Ringpuffer lschen
	mov		#0x0c00,w0
 	repeat	#276
 	clr		[w0++]
	nop
	
; Port A: b1, b0 = Ausgnge
	MOV 	#0x00, W0
	MOV 	W0, TRISA
	nop
; Port B: b15...b8 =Ausg, b7,6,5,4 = Eing, b3 = Ausg, b2 = Eing, b1,b0 = Ausg
	mov		#0b0000000011110100, W0
	mov		w0,TRISB
	nop
	
; Daten aus EEPROM holen
;	call	Eepromlesen
	                    
; Timer 1 Interrupt alle 26,4us
	clr		T1CON
	clr		TMR1
	mov		#0x0010,w0 		; int Clk / 8 = 0,275us
	mov		w0,T1CON
	mov		#182,w0			; 182x0,275=50us
	mov		w0,PR1
	BCLR 	IFS0,#T1IF 
	bset 	IEC0,#T1IE
	bset	T1CON,#TON

; RS232 Init
	mov		#194,w0
	mov		w0,U1BRG		; 9600 Bd
	mov		#0b1000010000000000,w0
	mov		w0,U1MODE
	mov		#0x0400,w0
	mov		w0,U1STA
	bclr	IFS0,#U1RXIF	; muss beim ersten mal gelscht sein
	bset	IEC0,#U1RXIE	; Rx Int erlauben
	mov		#rs232cpuffer,w0
	mov		w0,rspufferzgr1
	mov		w0,rspufferzgr2

; RXD auf Pin 6 (RPI34)
	mov		#0b0100010,w0
	mov		w0,RPINR18
; TXD auf pin 7 (RP35)
	mov		#0b00000100000000,w0
	mov		w0,RPOR0
	
; PSV aktivieren
	movpag	#psvpage(psvanfang),DSRPAG

; TFT
	call	Lcdinit
    mov     #1,w0
    mov     w0,schriftgroesse

; Hauptschleife
hp:	
	call	RS232control	; RS232
	nop
	nop
	nop
	Call	Lcdbed			; Sendet zum TFT
	nop
	nop
	nop
	goto	hp
		
;---------------------------------------------------
; Interrupt wird alle 50us aktiv
; Register W14 nur fr diese Int-Routine reserviert

__T1Interrupt:
	BCLR 	IFS0,#T1IF ; Reset Timer1 interrupt flag
	dec		w14,w14
	bra		z,t1inta
	retfie
t1inta:
	mov		#200,w14		; 200 x 50us = 10ms
    cp0     rs232ctimer
    bra     z,t1intb
	dec		rs232ctimer
t1intb:
	retfie

; ----------------------------------------------------
; Interrupt fr RS232 - Empfnger
; ----------------------------------------------------
__AltU1RXInterrupt:
__U1RXInterrupt:
	push.s
	bclr	IFS0,#U1RXIF
	mov		rspufferzgr1,w1
	mov		U1RXREG,w0
	mov.b	w0,[w1++]
	btsc	w1,#9
	mov		#rs232cpuffer,w1
altu1a:
	mov		w1,rspufferzgr1
	pop.s
	retfie

; fr Test -----------------------------------
; w0 wird verndert, ist egal weil sowieso ein Fehler vorliegt
	
__DefaultInterrupt:
	nop
	mov		#1,w0
	bra		divint
__OscillatorFail:
	nop
	mov		#2,w0
	bra		divint
__HardTrapError:
	nop
	mov		#3,w0
	bra		divint
__StackError:
	nop
	mov		#4,w0
	bra		divint
__MathError:
	nop
	mov		#5,w0
	bra		divint
__DMACError:
	nop
	mov		#5,w0
	bra		divint
__SoftTrapError:
    nop
	mov		#7,w0
divint:
	nop
	nop
	nop
	nop
	bra		divint
	RETFIE 
		